/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import mockit.coverage.CallPoint;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import org.jetbrains.annotations.NotNull;

public final class TestRun {
    private static boolean terminated;

    private TestRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lineExecuted(int fileIndex, int line) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            CallPoint callPoint = null;
            if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line)) {
                callPoint = CallPoint.create(new Throwable());
            }
            fileData.registerExecution(line, callPoint);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void branchExecuted(int fileIndex, int line, int branchIndex) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            CallPoint callPoint = null;
            if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line, branchIndex)) {
                callPoint = CallPoint.create(new Throwable());
            }
            fileData.registerExecution(line, branchIndex, callPoint);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nodeReached(@NotNull String file, int firstLineInMethodBody, int node) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.pathCoverageInfo.registerExecution(firstLineInMethodBody, node);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToStaticField(classAndFieldNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfStaticField(classAndFieldNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@NotNull Object instance, @NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToInstanceField(instance, classAndFieldNames);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@NotNull Object instance, @NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfInstanceField(instance, classAndFieldNames);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static void terminate() {
        terminated = true;
    }
}

